#version 330
#extension GL_EXT_gpu_shader4 : enable
//Smooth Julia set with rainMod01.fsh  by martytram
//https://www.shadertoy.com/view/wsKGDc
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define MAX_ITER 1000.
#define R 100.
#define S(a,b,c) smoothstep(a,b,c)

//conversion helper
float f(float n, vec3 hsl){
    float k = mod(n+hsl.x*12., 12.);
    float a = hsl.y*min(hsl.z, 1.-hsl.z);
    return hsl.z-a*max(min(k-3., min(9.-k, 1.)),-1.);
}
// hsl in range <0, 1>^3
vec3 hsl2rgb(vec3 hsl){
    return vec3(f(0.,hsl), f(8.,hsl), f(4.,hsl));
}

vec3 hue2rgb(float hue){
    return hsl2rgb(vec3(hue, 1., .5));
}

vec2 Rain(vec2 uv, float t){
    t*= 40.;
    vec2 aspect = vec2(3.,1.);
    vec2 st = uv*aspect;
    
    vec2 id = floor(st);
    st.y+=t*.22;
    float n = fract(sin(id.x*256.45)*85.);
    st.y += n;
    uv.y += n;
    id = floor(st);
    st = fract(st)-.5;
    
    t+= fract(sin(id.x*56.45+id.y*485.)*155.)*6.28;
    
    float y = -sin(t+sin(t+.5*sin(t)))*0.43;
    float x = (fract(sin(id.x*384.45)*id.y*288.)-.5)*.6;
    vec2 p1 = vec2(x, y);
    vec2 o1 = (st-p1)/aspect;
    float d = length(o1);
    
    float m1 = S(.07, .0, d);
    
    vec2 o2 = (fract(uv*aspect.x*vec2(1.,2.)-vec2(p1.x,0.))-.5)/vec2(1.,2.);
    d = length(o2);
    
    float m2 = S(0.2*(.5-st.y), .0, d) * S(-.1, .1, st.y-p1.y);
    
    //if(st.x>.46 || st.y>.49) m1 = 1.;
    
    return vec2(m1*o1*30.+m2*o2*10.);
}

vec3 julia(float zx, float zy, float cx, float cy){
    float iter = 0.;
    for ( ;zx * zx + zy * zy < R*R && iter<MAX_ITER; iter += 1.){
        float xtemp = zx*zx - zy*zy;
        zy = 2. * zx * zy + cy;
        zx = xtemp + cx;
    }
    
    float dist = length(vec2(zx,zy));
    float fracIter = log2(log(dist) / log(R)) - 1.;
    iter -= fracIter;
    vec3 col = hue2rgb(sqrt(iter/10.));
    return col;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = (gl_FragCoord.xy -.5*iResolution.xy)/iResolution.y;
    vec2 m = iMouse.xy/iResolution.xy;
    m-=.5;
    m*=2.;
    uv*=2.;
    float t = iTime;
    t*=.7;
    
    vec2 rain = Rain(uv*2., t*.13);
    rain += Rain(uv*3., t*.15) * .25;
    uv -= rain * 0.35;
    
    //vec3 col = julia(uv.x, uv.y, m.x, m.y);
    vec3 col = julia(uv.x, uv.y, .8*cos(t), .8*sin(t));
    gl_FragColor = vec4(col, 1.0);
}
